#include <i2c.h>
#include <p30fxxxx.h>

/*********************************************************************
*    Function Name:  CloseI2C										
*    Description:    This routine disables the I2C module by 
*                    clearing the I2CEN bit in I2CCON register.
*                    The MI2C and SI2C interrupts are disabled and 
*                    the corresponding IF flags are cleared
*    Parameters:     void									
*    Return Value:   void
*********************************************************************/

void CloseI2C(void)
{
	/* clear the I2CEN bit */
	I2CCONbits.I2CEN = 0;

	/* clear the SI2C & MI2C Interrupt enable bits */
	IEC0bits.SI2CIE = 0;
	IEC0bits.MI2CIE = 0;

	/* clear the SI2C & MI2C Interrupt flag bits */
	IFS0bits.SI2CIF = 0;
	IFS0bits.MI2CIF = 0;
}
